document.addEventListener('DOMContentLoaded', function () {
    const popupOverlay = document.querySelector('.popup-overlay');
    const videoPopup = document.getElementById('videoPopup');
    const closePopupBtn = document.querySelector('.close-popup');
    const popupTriggers = document.querySelectorAll('.popup-trigger');

    popupTriggers.forEach(function (trigger) {
        trigger.addEventListener('click', function () {
            const videoSource = trigger.getAttribute('data-video');
            videoPopup.src = videoSource;
            popupOverlay.style.display = 'flex';
            playVideo();
        });
    });

    closePopupBtn.addEventListener('click', function () {
        stopVideo();
        popupOverlay.style.display = 'none';
    });

    popupOverlay.addEventListener('click', function (event) {
        if (event.target === popupOverlay) {
            closePopupBtn.click();
        }
    });

    function playVideo() {
        if ('play' in videoPopup) {
            videoPopup.play();
        }
    }

    function stopVideo() {
        if ('pause' in videoPopup) {
            videoPopup.pause();
        }
        videoPopup.src = ''; // Detiene y vacía el video actual
    }
});




document.addEventListener('DOMContentLoaded', function () {
    const cajas = document.querySelectorAll('.caja');
    const menuItems = document.querySelectorAll('.cabezamenus li');
    const numeros = document.querySelector('.numeros');
    const principal = document.querySelector('body');
    const botonVolver = document.getElementById('botonVolver');

    cajas.forEach(function (caja) {
        caja.addEventListener('click', function () {
            const targetId = caja.getAttribute('data-target');
             
            mostrarSeccion(targetId);
            reiniciarClasesNumeros();
            agregarClaseNumeros(targetId);
             
        });
    });

    menuItems.forEach(function (item) {
        item.addEventListener('click', function () {
            const targetId = item.getAttribute('data-target');
            mostrarSeccion(targetId);
            reiniciarClasesNumeros();
            agregarClaseNumeros(targetId);
        });
    });

    // Asocia la función al botón Volver
    if (botonVolver) {
        botonVolver.addEventListener('click', volverAlHome);
    }

    function mostrarSeccion(id) {
        const secciones = document.querySelectorAll('.cajaprincipal');
        secciones.forEach(function (seccion) {
            seccion.classList.remove('mostrar');
        });

        const seccionTarget = document.getElementById(id);
        if (seccionTarget) {
            seccionTarget.classList.add('mostrar');
            const header = document.getElementById('mainHeader');
            if (id !== 'home' && !header.classList.contains('sidebar')) {
                header.classList.add('sidebar');
            }reproducirVideoEnSeccion(id);
        }
        mostrarTelon();
    }

    function reiniciarClasesNumeros() {
        numeros.className = 'numeros';
        principal.className = '';
    }

    function agregarClaseNumeros(targetId) {
        if (targetId) {
            numeros.classList.add(targetId);
            principal.classList.add(targetId);
        }
    }

    function volverAlHome() {
        const secciones = document.querySelectorAll('.cajaprincipal');
        secciones.forEach(function (seccion) {
            seccion.classList.remove('mostrar');
        });

        const header = document.getElementById('mainHeader');
        header.classList.remove('sidebar');

        const homeSection = document.getElementById('home');
        if (homeSection) {
            homeSection.classList.add('mostrar');
        }

        numeros.className = 'numeros';
        principal.className = '';
    }
});

// ----------------------------------------gsap-------------------------------------------------
window.addEventListener('load', function () {
    gsap.to(".caja", {
      opacity: 1,
      y: 0,
      duration: 1,
      ease: "power2.inOut",
    });
  
    ScrollTrigger.create({
      trigger: ".intro",
      start: "top center",
      end: "bottom center",
      animation: ".caja",
      toggleActions: "play none none none",
    });
 

  });
  
  function mostrarTelon() {
    const telon = document.getElementById('telon');

    // Mostrar el telón
    gsap.to(telon, {
      scaleX: 1, // Escala completa en X
      duration: 0.4,
      visibility: 'visible',
      onComplete: function () {
        // Acciones adicionales después de mostrar el telón

        // Esperar 2 segundos y luego ocultar el telón
        setTimeout(function() {
          ocultarTelon();
        }, 100);
      },
    });
  }

  function ocultarTelon() {
    const telon = document.getElementById('telon');

    // Ocultar el telón
    gsap.to(telon, {
      scaleX: 0, // Volver a la escala 0 en X
      duration: 0.4,
       
      onComplete: function () {
        // Acciones adicionales después de ocultar el telón
      },
    });
  }

// Obtener todos los divs con la clase .cajaprincipal
const divsCajaPrincipal = document.querySelectorAll('.cajaprincipal');

// Función para reproducir o pausar el video según si la caja está visible o no
function controlarVideo(div) {
  const video = div.querySelector('video');
  if (div.classList.contains('mostrar')) {
    video.play();
  } else {
    video.pause();
  }
}

// Llamamos a la función al cargar la página
window.addEventListener('DOMContentLoaded', () => {
  divsCajaPrincipal.forEach(div => {
    controlarVideo(div);
  });
});

// Agregar un evento para cada div
divsCajaPrincipal.forEach(div => {
  div.addEventListener('transitionend', () => {
    controlarVideo(div);
  });
});


function reproducirVideoEnSeccion(id) {
    const videoEnSeccion = document.querySelector(`#${id} video`);
    if (videoEnSeccion) {
        videoEnSeccion.play();
    }
}